<?php

// Set a custom error handler
/*set_error_handler(function ($errno, $errstr, $errfile, $errline) {
    // Log the error details
    error_log("Error [$errno]: $errstr in $errfile on line $errline");

    // You can display a custom message or take any action you want
    echo "Something went wrong! Please try again later.";

    // Stop further execution (optional)
    exit;
});

// Set a custom exception handler
set_exception_handler(function ($exception) {
    // Log the exception details
    error_log("Uncaught Exception: " . $exception->getMessage());

    // Display a custom message or take any action
    echo "An unexpected error occurred. Please contact support.";

    // Stop further execution
    exit;
});*/

// Handle fatal errors (shutdown errors)
register_shutdown_function(function () {
    $error = error_get_last();
    if ($error && ($error['type'] === E_ERROR || $error['type'] === E_PARSE)) {
        // Log the fatal error details
        error_log("Fatal Error: {$error['message']} in {$error['file']} on line {$error['line']}");

        // Display a custom message
        echo "A critical error occurred. Please try again later.";
    }
});

// Example code to trigger errors
// Uncomment these lines to test

// Trigger a warning (caught by set_error_handler)
 //echo $undefinedVar;

// Throw an exception (caught by set_exception_handler)
// throw new Exception("This is a test exception.");

// Trigger a fatal error (caught by register_shutdown_function)
 undefinedFunction();

?>
